#///////////////////////////////////////////////////////////////////////////////
#
# - Fit UV to Image -
#
#   Blender Add-on
#
#   Fit selected UV faces to Image bounds.
#
#   Programmed by Hikmet Koyuncu @ 2019
#
#///////////////////////////////////////////////////////////////////////////////

bl_info = {
    "name": "Fit UV to Image",
    "author": "Hikmet Koyuncu",
    "version": (1, 1),
    "blender": (2, 80, 0),
    "location": "UV/Image Editor > Sidebar",
    "description": "Fit UV to Image.",
    "category": "UV",
    'wiki_url': '',
    'tracker_url': ''}

import bpy
import bmesh

def FitUVToImage():
    obj = bpy.context.active_object
    data = obj.data
    mesh = bmesh.from_edit_mesh(data)
    
    uv_layer = mesh.loops.layers.uv.verify()
    mesh.faces.layers.face_map.verify()
    
    minX = minY = float('inf')
    maxX = maxY = float('-inf')
    
    for f in mesh.faces:
        for l in f.loops:
            luv = l[uv_layer]
            if luv.select:
                if luv.uv.x > maxX:
                    maxX = luv.uv.x
                if luv.uv.x < minX:
                    minX = luv.uv.x
                    
                if luv.uv.y > maxY:
                    maxY = luv.uv.y
                if luv.uv.y < minY:
                    minY = luv.uv.y
                
    minX *= 2;
    maxX *= 2;
    
    width  = maxX - minX
    height = maxY - minY
    
    scaleX = scaleY = 1.0
    if (bpy.context.scene.FUTI_FitUVToImage_X == True):
        scaleX = 2.0 / width
        
    if (bpy.context.scene.FUTI_FitUVToImage_Y == True):
        scaleY = 1.0 / height
    
    bpy.ops.transform.resize(value=(scaleX, scaleY, 1.0), constraint_axis=(False, False, False), orient_type='GLOBAL', mirror=False, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1)
    
    bmesh.update_edit_mesh(data)
    

    if (bpy.context.scene.FUTI_FitUVToImage_X == True or bpy.context.scene.FUTI_FitUVToImage_Y == True):
        minX = minY = float('inf')
        maxX = maxY = float('-inf')
        
        for f in mesh.faces:
            for l in f.loops:
                luv = l[uv_layer]
                if luv.select:
                    if luv.uv.x > maxX:
                        maxX = luv.uv.x
                    if luv.uv.x < minX:
                        minX = luv.uv.x
                        
                    if luv.uv.y > maxY:
                        maxY = luv.uv.y
                    if luv.uv.y < minY:
                        minY = luv.uv.y

        if (bpy.context.scene.FUTI_FitUVToImage_X == True and bpy.context.scene.FUTI_FitUVToImage_Y == False):
            for f in mesh.faces:
                for l in f.loops:
                    luv = l[uv_layer]
                    if luv.select:
                        luv.uv.x += 0.0 - minX
        elif (bpy.context.scene.FUTI_FitUVToImage_X == False and bpy.context.scene.FUTI_FitUVToImage_Y == True):
            for f in mesh.faces:
                for l in f.loops:
                    luv = l[uv_layer]
                    if luv.select:
                        luv.uv.y += 1.0 - maxY
        elif (bpy.context.scene.FUTI_FitUVToImage_X == True and bpy.context.scene.FUTI_FitUVToImage_Y == True):
            for f in mesh.faces:
                for l in f.loops:
                    luv = l[uv_layer]
                    if luv.select:
                        luv.uv.x += 0.0 - minX
                        luv.uv.y += 1.0 - maxY
    

# FIT TO IMAGE
class FUTI_FitUVToImage(bpy.types.Operator):
    bl_label = "Fit UV to Image"
    bl_description = "Fit selected UV faces to image bounds."
    bl_idname = "scene.futi_fit_uv_to_image"
    
    def execute(self, context):
        FitUVToImage()
        return {"FINISHED"}


# =====  GUI  =====
class SCENE_PT_FUTI_FitUVToImage(bpy.types.Panel):
    bl_label = "Fit UV to Image"
    bl_category = "Tools"
    bl_space_type = "IMAGE_EDITOR"
    bl_region_type = "UI"
    
    # -----  Property'ler Tanimlaniyor  -----  
    bpy.types.Scene.FUTI_FitUVToImage_X = bpy.props.BoolProperty( 
                                                name        = "futi_fit_uv_to_image_x",
                                                description = "Fit UV to Image on X axis.",
                                                default=True )
                                                
    bpy.types.Scene.FUTI_FitUVToImage_Y = bpy.props.BoolProperty( 
                                                name        = "futi_fit_uv_to_image_y",
                                                description = "Fit UV to Image on Y axis.",
                                                default=True )
    
    
    def draw(self, context):
        scn = bpy.context.scene
    
        layout = self.layout
        
        row = layout.row()
        row.operator("scene.futi_fit_uv_to_image", text="Fit UV to Image")
        
        row = layout.row(align=True)
        row.alignment = 'LEFT'
        row.prop( bpy.context.scene, 'FUTI_FitUVToImage_X', text = "X" )
        row.prop( bpy.context.scene, 'FUTI_FitUVToImage_Y', text = "Y" )
        
        
def register():
    bpy.utils.register_class(FUTI_FitUVToImage)
    bpy.utils.register_class(SCENE_PT_FUTI_FitUVToImage)


def unregister():
    bpy.utils.unregister_class(FUTI_FitUVToImage)
    bpy.utils.unregister_class(SCENE_PT_FUTI_FitUVToImage)


# MAIN
if __name__ == "__main__":
    register()
    