import sys
import argparse
import math

parser = argparse.ArgumentParser(description="Scales and Rotates a Wavefront OBJ file")

parser.add_argument("inputfile", type=str, help="Inputfile")
parser.add_argument("outputfile", type=str, help="Outputfile")
parser.add_argument("scale", type=float, help="Scalefactor")
parser.add_argument("rotate", type=float, help="Rotation")

args = parser.parse_args()

def scale_and_rotate_obj(input_file, output_file, scale_factor, rotation_degrees):
    theta = math.radians(rotation_degrees)
    cos_theta = math.cos(theta)
    sin_theta = math.sin(theta)

    with open(input_file, "r") as f_in, open(output_file, "w") as f_out:
        for line in f_in:
            if line.startswith("v "):
                parts = line.split()
                x = float(parts[1]) * scale_factor
                y = float(parts[2]) * scale_factor
                z = float(parts[3]) * scale_factor

                # Y axis rotation
                x_rot = x * cos_theta + z * sin_theta
                z_rot = -x * sin_theta + z * cos_theta

                f_out.write(f"v {x_rot} {y} {z_rot}\n")
            else:
                f_out.write(line)

scale_and_rotate_obj(args.inputfile, args.outputfile, args.scale, args.rotate)